require_relative '../module/DateUtility'

class CalendarPicker
  include DateUtility

  MONTHS = [\
      "Jan",
      "Feb",
      "Mar",
      "Apr",
      "May",
      "Jun",
      "Jul",
      "Aug",
      "Sep",
      "Oct",
      "Nov",
      "Dec"
  ]

  def initialize(driver)
    @driver = driver
  end

  def clickNthCalendarPicker(nThCalendar)
    elements = @driver.elements(:css => "div.datepicker")
    elements[nThCalendar - 1].when_present
    elements[nThCalendar - 1].click
  end

  def isCalendarDisplayed()
    element = @driver.element(:css => "div.datepicker")
    return element.visible?
  end

  def getVisibleCalendar()
    calendar = nil
    calendar = @driver.element(:css=>'div.datepicker')
=begin
    elements =  @driver.elements(:css => "div.datepicker")
    count = elements.length
    for i in 0..( count - 1 )
      if elements[i].visible?
        calendar = elements[i]
      end
    end
=end

    return calendar
  end

  def isNextButtonVisible()
    element = getVisibleCalendar()
    return element.th(:css =>  ".next").visible?
  end

  def isPreviousButtonVisible()
    element = getVisibleCalendar()
    return element.th(:css =>  ".prev").visible?

  end

  def clickPreviousButton()
    element = getVisibleCalendar()
    previousMonthBtn = element.th(:css =>  ".prev")
    previousMonthBtn.click
  end

  def clickPreviousYearButton()
    element = getVisibleCalendar()
    previousMonthBtn = element.th(:css =>  ".datepicker-months .prev")
    previousMonthBtn.click
  end

  def clickNextButton()
    element = getVisibleCalendar()
    element.th(:css =>  ".next").click

  end


  def clickNextYearButton()
    element = getVisibleCalendar()
    element.th(:css =>  ".datepicker-months .next").click
    puts ("oink")
  end

  def clickTitleToggleButton()
    element =  getVisibleCalendar()
    if element.th(:css => "div.datepicker-days .datepicker-switch").visible?
      element.th(:css => "div.datepicker-days .datepicker-switch").click
    elsif element.th(:css => "div.datepicker-months .datepicker-switch").visible?
      element.th(:css => "div.datepicker-months .datepicker-switch").click
    elsif element.th(:css => "div.datepicker-years .datepicker-switch").visible?
      element.th(:css => "div.datepicker-years .datepicker-switch").click
    end
  end

  def getTitleToggleButtonText()
    element =  getVisibleCalendar()
    if element.th(:css => "div.datepicker-days .datepicker-switch").visible?
      return element.th(:css => "div.datepicker-days .datepicker-switch").text
    elsif element.th(:css => "div.datepicker-months .datepicker-switch").visible?
      return element.th(:css => "div.datepicker-months .datepicker-switch").text
    elsif element.th(:css => "div.datepicker-years .datepicker-switch").visible?
      return element.th(:css => "div.datepicker-years .datepicker-switch").text
    end

  end


  def getCurrentDay()
    element = getVisibleCalendar()

    begin
      day = element.td(:css => ".datepicker-days table.table-condensed tr td.active")
      if day.text != nil
        #puts "current Day " + day.text
        if(day.text.to_i < 10)
          return "0" + day.text
        else
          return day.text
        end
      else
        return ""
      end
    rescue Exception=>e
      return ""
    end


  end

  def getCurrentMonth()
    headerText= getTitleToggleButtonText()
    monthAndYear = headerText.split(" ")
    return monthAndYear[0]
  end

  def getcurrentYear()
    headerText= getTitleToggleButtonText()
    monthAndYear = headerText.split(" ")
    return monthAndYear[1]
  end


  def pickDay(day)
    element =  getVisibleCalendar()
    buttons = element.tds(:css => "div.datepicker table.table-condensed tr td")
    count = buttons.length
    for i in (day.to_i - 1)..(count - 1) do
      #puts "## i  " + i.to_s + "  =>" + buttons[i].text
      #puts "day is   " + day.to_i.to_s
      if(buttons[i].text == day.to_i.to_s)
        if (buttons[i].attribute_value("class").include?  "disabled")
          #puts "button "  + buttons[i].text + " is disabled."
        else
          #puts ("button clicked : " + buttons[i].text)
          buttons[i].click
        end

        break
      end
    end

    return;
  end

  def pickMonth(month)
    element =  getVisibleCalendar()
    buttons = element.spans(:css => "div.datepicker .table-condensed tr td span")
    count = buttons.length

    for i in 0..11 do
      #puts ("button Text:  " + buttons[i].text)

      if(buttons[i].text == month.to_s)

        if (buttons[i].attribute_value("disabled") == "true")
          #puts "button "  + buttons[i].text + " is disabled."
        else
          #puts ("button clicked : " + buttons[i].text)
          buttons[i].click
        end
        break
      end
    end

    return;
  end

  def isDayEnabled(day)
    isEnabled = false
    element =  getVisibleCalendar()
    buttons = element.tds(:css => ".datepicker-days table.table-condensed tr td")
    count = buttons.length
    #puts "buttons count " + count.to_s

    for i in (day.to_i - 1)..(count - 1) do
      #puts ("button " + buttons[i].text)

      if(buttons[i].text == day.to_i.to_s)
        if (buttons[i].attribute_value("class").include? "disabled")
         # puts "button "  + buttons[i].text + " is disabled."
        else

          #puts "??  "  + buttons[i].attribute_value("class")
          isEnabled = true
        end

        break
      end

    end

    return isEnabled
  end

  def isMonthOrYearEnabled(text)
    isEnabled = false
    element =  getVisibleCalendar()
    #puts "text is " + text

    if element.div(:css=>'.datepicker-months').visible?
      spans = element.spans(:css => ".datepicker-months .table-condensed tr td span.month")
    elsif element.div(:css=>'.datepicker-years').visible?
     spans = element.spans(:css => ".datepicker-years .table-condensed tr td span.year")
    end

    count = spans.length
    #puts "number of span " + count.to_s

    for i in 0..(count - 1) do
      if (spans[i].text == text.to_s and spans[i].attribute_value("class").include? "disabled")
        puts "span"  + spans[i].text + " is disabled."
        break
      elsif spans[i].text == text.to_s
        isEnabled = true
        break
      end

    end

    return isEnabled
  end


  def areAllMonthsDisplayed()
    isDisplayed = true
    element =  getVisibleCalendar()
    monthButtons = element.spans(:css => ".datepicker-months .table-condensed tr td span")
    count = monthButtons.length

    for i in 0..(count - 1) do
      if monthButtons[i].text != MONTHS[i]
        isDisplayed = false
        #puts ("Month " + monthButton[i]  + "  != " + MONTHS[i])
        break
      end
    end

    return isDisplayed

  end

  def flipToYear(year)

    #puts "Currnet year : "  + getcurrentYear()
    yearDifference = getcurrentYear().to_i - year.to_i
    #puts "Year Difference : " + yearDifference.to_s

    clickTitleToggleButton

    if (yearDifference < 0)
      0.downto( yearDifference + 1) {clickNextYearButton}
    elsif yearDifference > 0
      for i in 0..(yearDifference - 1) do
        clickPreviousYearButton()
      end
    end
  end

  def flipToMonth(month)
    month = MONTHS.index(month) + 1
    #puts "Month in # " + month.to_s
    monthDifference = MONTHS.index(getCurrentMonth()).to_i - month.to_i

    #puts "Month Difference: " + monthDifference.to_s

    if monthDifference < 0
      monthDifference.downto(0){  clickNextButton  }
    elsif monthDiff > 0
      for i in 0..(monthDiff - 1) do
        clickPreviousButton()
      end
    end
  end

  def pick(dateStr)
    flipToYear(getYear(dateStr))
    pickMonth(getMonthOfYear(dateStr, "%b"))
    #puts "Selected Month and Year " + getTitleToggleButtonText
    #puts "selected date "  + dateStr
    pickDay(getDay(dateStr))
  end

end